.plugin asm86
#include "RBP2.inc"

.org $D748
 
 call _clrLCD
 ld hl,$FF90
 push hl ; save hl to stack
 pop de  ; retore it to de
 inc de  ; de now = hl+1
 ld bc,112
 ld (hl),$FF
 ldir
 call _runindicoff
 set 3,(iy+5)
 ld hl,Menu
 ld de,$3900
 call PutSmall
 ld e,30
; you may have noticed that e doubled each time before
; so we're going to introduce a doubling loop instead
; of repetitive code. yes, I'm aware it takes more space
; but it's a good oppurtunity for the add instruction
 ld b,3  ; setup for 4 loops
Dloop:    
 push bc ; save bc to stack
 push de ; stack = de,bc
 call PutSmall
 pop de  ; get de from stack
 pop bc  ; get bc from stack
 ld a,e  ; store e in the accumulator
 add a,a ; double it
 ld e,a  ; put the value back in e
 djnz Dloop ; decrease b and loop until b=0
KeyLup:
 ld a,$FF    ; a=255
 out (1),a   ; Clear keyport (port 1), because of $FF
 ld a,$BF    ; a=191
 out (1),a   ; Look at top row (because of $BF)
 in a,(1)    ; get the value back
 bit 4,a     ; did you press F1
 jp z,NoGame ; if so, goto Play
 bit 3,a     ; did you press F2
 jp z,Invert ; if so, goto Cool
 bit 2,a     ; did you press F3
 jp z,Scroll ; if so, goto Cool
 bit 0,a     ; did you press F5
 jr nz,KeyLup ; if no function key was pressed start over (nz is 'false')
Quit:
 res 3,(iy+5)
 res 5,(iy+0)
 call _clrLCD
 jp _homeUp
 
Scroll:
 res 3,(iy+5)
 ld hl,Wow
 ld de,$0000
 ld b,40
Sloop1:
 call SaveText
 inc e
 inc d
 djnz Sloop1
 ld b,40
Sloop2:
 call SaveText
 inc e
 dec d
 djnz Sloop2
 jr KeyLup

SaveText:
 push hl
 call PutSmall
 pop hl
 ret
 
Invert:
 ld hl,$FC00
 ld de,1024
InvLp:
 ld a,(hl)
 cpl
 ld (hl),a
 dec de
 inc hl
 ld a,d
 or e
 jr nz,InvLp
 jr KeyLup
 
NoGame:
 ld hl,Play
 ld de,$0000
 call PutSmall
 jr KeyLup
 
PutSmall:
 ld (_penCol),de
 jp _vputs

Menu:
.db "Play",0,"Fun!",0,"Cool",0,"X",0
Play:
.db "Silliness",0
Wow:
.db "Scrolling Text",0

.end